﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;


namespace PI.ZB.N1200.ELearning.WinForms.Config
{
    public partial class UCOptionsDetails : PI.FM.N000.Base.WinForms.Controls.UCBODetails<PI.FM.N001.Account.BL.BO.Dummy, PI.FM.N001.Account.BL.BO.Dummy.Search>
    {
        private const int _IndexTabKnowledgeTest = 0;
        private const int _IndexTabAdvancedTest = 1;
        private const int _IndexTabEduFarma = 2;
        private const int _IndexTabAvatar = 3;
        private const int _IndexTabAdditonalConfig = 4;
        protected     int _IndexTabSystemInformation        = 5;

        private PI.FM.N001.Account.BL.Account _blAccount = null;

        private PI.FM.N005.VariableRepository.BL.VariableRepository _blVariableRepository = null;

        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private UCTabKnowledgeTest _tabKnowledgeTest = null;

        private UCTabAdvancedTest _tabAdvancedTest = null;

        private UCTabEduFarma _tabEduFarma = null;

        private UCTabAvatar _tabAvatar = null;

        private UCTabAdditionalConfig _tabAdditionalConfig = null;

        public UCTabKnowledgeTest TabKnowledgeTest
        {
            get
            {
                if (_tabKnowledgeTest == null)
                {
                    _tabKnowledgeTest = new UCTabKnowledgeTest();
                }
                return _tabKnowledgeTest;
            }
        }

        public UCTabAdvancedTest TabAdvancedTest
        {
            get
            {
                if (_tabAdvancedTest == null)
                {
                    _tabAdvancedTest = new UCTabAdvancedTest();
                }
                return _tabAdvancedTest;
            }
        }

        public UCTabEduFarma TabEduFarma
        {
            get
            {
                if (_tabEduFarma == null)
                {
                    _tabEduFarma = new UCTabEduFarma();
                }
                return _tabEduFarma;
            }
        }

        public UCTabAvatar TabAvatar
        {
            get
            {
                if (_tabAvatar == null)
                {
                    _tabAvatar = new UCTabAvatar();
                }
                return _tabAvatar;
            }
        }

        public UCTabAdditionalConfig TabAdditionalConfig
        {
            get
            {
                if (_tabAdditionalConfig == null)
                {
                    _tabAdditionalConfig = new UCTabAdditionalConfig();
                }
                return _tabAdditionalConfig;
            }
        }

        internal PI.FM.N001.Account.BL.Account BLAccount
        {
            get
            {
                if (_blAccount == null)
                {
                    _blAccount = new PI.FM.N001.Account.BL.Account(Environment);
                }

                return _blAccount;
            }
        }

        internal PI.FM.N005.VariableRepository.BL.VariableRepository BLVariableRepository
        {
            get
            {
                if (_blVariableRepository == null)
                {
                    _blVariableRepository = new PI.FM.N005.VariableRepository.BL.VariableRepository(Environment);
                }

                return _blVariableRepository;
            }
        }

        internal virtual PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        protected int IndexTabSystemInformation
        {
            set
            {
                _IndexTabSystemInformation = value;
            }
            get
            {
                return _IndexTabSystemInformation;
            }
        }

        public UCOptionsDetails()
        {
            InitializeComponent();

            AddStandardControlTabs();
            MinimumHorizontalSize = 400;
            MinimumVerticalSize = 190;
        }

        protected void AddStandardControlTabs()
        {
            this.AddControlAtTab(_IndexTabKnowledgeTest, TabKnowledgeTest, "Testy wiedzy");
            this.AddControlAtTab(_IndexTabAdvancedTest, TabAdvancedTest, "Testy umiejętności");
            this.AddControlAtTab(_IndexTabEduFarma, TabEduFarma, "eduFarma");
            this.AddControlAtTab(_IndexTabAvatar, TabAvatar, "Awatar");
            this.AddControlAtTab(_IndexTabAdditonalConfig, TabAdditionalConfig, "Dodatkowe ustawienia");
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment ParentEnvironment)
        {
            base.Initialize(ParentPlugIn, ParentEnvironment);

            TabKnowledgeTest.Initialize(this, Environment, ParentPlugIn);
            TabAdvancedTest.Initialize(this, Environment, ParentPlugIn);
            TabEduFarma.Initialize(this, Environment, ParentPlugIn);
            TabAvatar.Initialize(this, Environment, ParentPlugIn);
            TabAdditionalConfig.Initialize(this, Environment, ParentPlugIn);

            Enabled = true;
        }

        protected override Gemini.Core.BL.Base.MethodResult DoRemove()
        {
            return new Gemini.Core.BL.Base.MethodResult();
        }

        protected override Gemini.Core.BL.Base.MethodResult DoSave()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult(true);

            _methodResult.SetSuccess = TabKnowledgeTest.Save();
            _methodResult.SetSuccess = TabAdvancedTest.Save();
            _methodResult.SetSuccess = TabEduFarma.Save();
            _methodResult.SetSuccess = TabAvatar.Save();
            _methodResult.SetSuccess = TabAdditionalConfig.Save();

            return _methodResult;
        }

        public override void Restore()
        {
            TabKnowledgeTest.Restore();
            TabAdvancedTest.Restore();
            TabEduFarma.Restore();
            TabAvatar.Restore();
            TabAdditionalConfig.Restore();
        }

        protected override bool DoRestore(long? ID)
        {
            return true ;
        }
    }
}
